import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {NavLink} from "react-router-dom";
import Ionicon from "react-ionicons";
import Loading from "../../Loading/Loading";
import ReactTable from "react-table";
import DeleteButton from "../../DeleteButton";
import {Button, Modal, ModalBody, ModalHeader} from "reactstrap";
import gql from 'graphql-tag';
import BlinkDot from "../../Loading/BlinkDot";
import {graphql, compose, withApollo} from "react-apollo";
import {futch} from "../../../utils";



class InterventoDocumentiComponent extends Component {

    selectedFile = null;

    constructor(props) {
        super(props);
        this.state = {
            isUploadModalOpen: false,
            submittingDocument: false,
            uploadDocumentError: false,
            uploadDocumentStatus: "",
            columns: [
                {
                    Header: "Nome File",
                    accessor: "nomeFile",
                },
                		 {
          Header: "Azioni",
			 width:200,
          Cell: (row) => (
            <div style={{display: 'flex', alignItems: 'center'}}>
              <div className="btn-group btn-group-sm" style={{margin: '0 auto'}}>
                <Button className="btn ionicon-btn btn-light" onClick={() => window.open('/LifeEremitaWeb/download/'+row.original.uuid)}>
                  <Ionicon icon="ios-download-outline" />
                </Button>
                <DeleteButton id={"delete-" + row.original.id} size={"sm"} onDelete={() => this.onDeleteItem(row.original.id)}>
                  <Ionicon icon="ios-trash-outline" color="#ffffff" />
                </DeleteButton>
              </div>
            </div>
          )
        }
            ],
        };

        this.toggleUploadModal = this.toggleUploadModal.bind(this);
        this.handleChange = this.handleChange.bind(this);
        this.onSubmitDocument = this.onSubmitDocument.bind(this);
	this.onDeleteItem = this.onDeleteItem.bind(this)
    }

    toggleUploadModal() {
        this.setState({
            isUploadModalOpen: !this.state.isUploadModalOpen,
        });
    }

    handleChange(event) {
        event.preventDefault();
        console.log(event.target.files[0]);
        this.selectedFile = event.target.files[0];
    }

    componentWillUnmount() {
        this.selectedFile = null;
    }

    onSubmitDocument(event) {
        const {client} = this.props;
        let documento;

        event.preventDefault();
        this.setState({
            uploadDocumentStatus: "Creazione della Risorsa",
            submittingDocument: true,
            uploadDocumentError: false,
        });

        client.mutate({
            mutation: gql`
                mutation {
                    updateDocumento(documento: {}) {
                        id
                        uuid
                        nomeFile
                    }
                }
            `,
        }).then(result => {

            documento = result.data.updateDocumento;

            const body = new FormData();
            body.append("file", this.selectedFile);
            body.append("uuid", result.data.updateDocumento.uuid);
            return futch("/upload", {method: "POST", body: body}, (progressEvent) => {
                const percent = Math.round((progressEvent.loaded / progressEvent.total) * 100);
                this.setState({uploadDocumentStatus: percent + "% - Upload del file in corso"});
            });
        }).then(result => {
            const resultJson = JSON.parse(result);
            if(resultJson.risultato === "error") {
                client.mutate({
                    variables: {
                        id: documento.id,
                    },
                    mutation: gql`mutation($id: Long) {
                        deleteDocumento(id: $id)
                    }`
                });
                throw new Error(result);
            }

            return client.mutate({
                variables: {
                    intervento: {
                        id: this.props.data.intervento.id,
                    },
                    documento: {
                        id: documento.id,
                    }
                },
                mutation: gql`
                    mutation($intervento: InterventoInput, $documento: DocumentoInput) {
                        addInterventoDocumento(intervento: $intervento, documento: $documento) {
                            id
                        }
                    }
                `,
            })
        }).then(result => {
            this.setState({
                uploadDocumentError: false,
                uploadDocumentStatus: "",
                submittingDocument: false,
                isUploadModalOpen: false,
            });
            this.props.data.refetch();
        }).catch(err => {
            this.setState({
                uploadDocumentError: true,
                uploadDocumentStatus: "",
                submittingDocument: false,
            });
        });

        return false;
    }

  async onDeleteItem(id) {
    const { client } = this.props

    const result = await client.mutate({
      mutation: gql`mutation($documento: DocumentoInput, $m: InterventoInput) {
          removeInterventoDocumento(intervento: $m, documento: $documento) {
              id
          }
      }`,
      variables: {
        documento: {
          id: id
        },
        m: {
          id: this.props.data.intervento.id
        }
      }
    })
    this.props.data.refetch()
  }

    render() {
        const {
            data,
        } = this.props;

        const {
            columns,
            isUploadModalOpen,
        } = this.state;

        if(data.error) {
            return(<div className="text-danger">
                Errore nella ricezione dei dati
            </div>)
        }

        if(data.loading) {
            return <Loading/>;
        }

        return (<div className="container-fluid">
            <div className="btn-toolbar" style={{backgroundColor: '#fff'}}>
                <div className="btn-group mr-2">
                    <button className="btn ionicon-btn btn-light" onClick={this.toggleUploadModal} type="button">
                        <Ionicon icon="ios-cloud-upload-outline" style={{marginRight: '5px', marginLeft: '-8px'}} />
                        Carica Documento
                    </button>
                </div>
            </div>
            <ReactTable
                loading={data.loading}
                noDataText={"Nessun Documento Presente"}
                className="-highlight"
                data={data.intervento.documenti}
                style={{}}
          	defaultPageSize={100}
	  	minRows={3}
	  	showPagination={false}
                nextText="Avanti"
                previousText="Indietro"
                loadingText="Caricamento in corso..."
                rowsText="elementi"
                ofText="di"
                pageText="Pagina"
                columns={columns} />

            <Modal isOpen={isUploadModalOpen} toggle={this.toggleUploadModal}>
                <ModalHeader toggle={this.toggleUploadModal}>
                    Carica Nuovo Documento
                </ModalHeader>
                <ModalBody>
                    <form onSubmit={this.onSubmitDocument}>
                        <div className="form-group">
                            <label>Documento</label>
                            <input disabled={this.state.submittingDocument} type="file" onChange={this.handleChange} className="form-control-file" />
                            <small className="form-text text-muted">Seleziona il documento da allegare a questo intervento.</small>
                        </div>

                        {this.state.submittingDocument && <div style={{margin: "10px 0"}} className="text-info">
                            {this.state.uploadDocumentStatus}
                            <BlinkDot/>
                            <BlinkDot/>
                            <BlinkDot/>
                        </div>}

                        {this.state.uploadDocumentError && <div style={{margin: "10px 0"}} className="text-danger">
                            Errore durante l'upload del file
                        </div>}

                        <div>
                            <button disabled={this.state.submittingDocument} type="submit" className="btn btn-primary">
                                Carica Documento
                            </button>
                        </div>
                    </form>
                </ModalBody>
            </Modal>
        </div>);
    }
}

const InterventoDocumenti = withApollo(InterventoDocumentiComponent);

export default InterventoDocumenti;

InterventoDocumenti.defaultProps = {};

InterventoDocumenti.propTypes = {};
